; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands are given below. Delete, add, or modify as you wish.

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = a+b
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd"  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup"   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holda"
command = /a
time = 1

[Command]
name = "holdb"
command = /b
time = 1

;-| Special |--------------------------------------------------------------
[Command]
name = "runfwd"
command = /$F, /a
time = 1

[Command]
name = "runback"
command = /$B,  /a
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in. 


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
;Crouch
[State -1]
type = ChangeState
value = 11
triggerall = command = "holddown"
trigger1 = stateno = 0
trigger1 = ctrl = 1
trigger2 = stateno = 1
trigger3 = stateno = 7
trigger4 = stateno = 20
trigger5 = stateno = 107
trigger6 = stateno = 108

;---------------------------------------------------------------------------
;RunFwd
[State -1]
type = ChangeState
value = 107
triggerall = command = "holdfwd"
triggerall = command = "holda"
trigger1 = stateno = 0
trigger1 = ctrl = 1
trigger2 = stateno = 1
trigger3 = stateno = 20
trigger4 = stateno = 108

;---------------------------------------------------------------------------
;RunBack
[State -1]
type = ChangeState
value = 108
triggerall = command = "holdback"
triggerall = command = "holda"
trigger1 = stateno = 0
trigger1 = ctrl = 1
trigger2 = stateno = 1
trigger3 = stateno = 20
trigger4 = stateno = 107

;---------------------------------------------------------------------------
;Walk
[State -1]
type = ChangeState
value = 20
triggerall = command = "holdfwd" || command = "holdback"
triggerall = command != "holda"
trigger1 = stateno = 0
trigger1 = ctrl = 1
trigger2 = stateno = 1
trigger3 = stateno = 107
trigger4 = stateno = 108

;===========================================================================
;---------------------------------------------------------------------------
;Jump_up
[State -1]
type = ChangeState
value = 200
triggerall = command = "b"
trigger1 = stateno = 0
trigger1 = ctrl = 1
trigger2 = stateno = 1
trigger3 = stateno = 7
trigger4 = stateno = 11
trigger5 = stateno = 20
trigger6 = stateno = 107
trigger7 = stateno = 108

;---------------------------------------------------------------------------
;Grow
[State -1]
type = ChangeState
value = 9999
triggerall = command = "c"
triggerall = Var(1) = 1 ;Size is small
triggerall = life > 50
trigger1 = stateno = 0
trigger1 = ctrl = 1
trigger2 = stateno = 1
trigger3 = stateno = 7
trigger4 = stateno = 11
trigger5 = stateno = 20
trigger6 = stateno = 107
trigger7 = stateno = 108
trigger8 = stateno = 200
trigger9 = stateno = 210
trigger10 = stateno = 209
